/*=============================================================================
  Copyright (C) 2022 Allied Vision Technologies.  All Rights Reserved.

  Redistribution of this file, in original or modified form, without
  prior written consent of Allied Vision Technologies is prohibited.

-------------------------------------------------------------------------------

  File:        LocalDevice.h

  Description: Definition of class VmbCPP::LocalDevice.

-------------------------------------------------------------------------------

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF TITLE,
  NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR  PURPOSE ARE
  DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED  
  AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR 
  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=============================================================================*/

#ifndef VMBCPP_LOCALDEVICE_H
#define VMBCPP_LOCALDEVICE_H

/**
* \file             LocalDevice.h
*
* \brief            Definition of class VmbCPP::LocalDevice.
*/

#include <VmbC/VmbC.h>

#include "PersistableFeatureContainer.h"
#include "VmbCPPCommon.h"

namespace VmbCPP {

/**
 * \brief A module providing access to the features of the local device GenTL module. 
 */
class LocalDevice : public PersistableFeatureContainer
{
public:
  
    /**  
    *  \brief     Creates an instance of class LocalDevice
    * 
    *  \param[in] handle    The handle of the local device
    */  
    IMEXPORT LocalDevice( VmbHandle_t handle);

    // default destructor auto-generated by compiler
    
    /**
     * \brief Object is not copyable 
     */
    LocalDevice(const LocalDevice&) = delete;

    /**
     * \brief Object is not copyable
     */
    LocalDevice& operator=(const LocalDevice&) = delete;

private:
    
};    
    
} // namespace VmbCPP

#endif